module pind.samples.ja.contracts.contracts_2;

import std.stdio;

/* 2つの変数に合計を分配する。
 *
 * 最初に変数1に分配するが、
 * その変数に7以上を与えることはない。
 * 残りの合計は変数2に分配される。 */
void distribute(int sum, out int first, out int second)
in {
    assert(sum >= 0, "sum cannot be negative");

} out {
    assert(sum == (first + second));

} do {
    first = (sum >= 7) ? 7 : sum;
    second = sum - first;
}

unittest {
    int first;
    int second;

    // 合計が0の場合は、両方が0でなければならない
    distribute(0, first, second);
    assert(first == 0);
    assert(second == 0);

    // 合計が7未満の場合は、すべてを
    // 最初の変数に割り当てる
    distribute(3, first, second);
    assert(first == 3);
    assert(second == 0);

    // 境界条件をテストする
    distribute(7, first, second);
    assert(first == 7);
    assert(second == 0);

    // 合計が7以上の場合は、最初の変数に7を割り当て
    // 残りを2番目の変数に割り当てる
    distribute(8, first, second);
    assert(first == 7);
    assert(second == 1);

    // ランダムな大きな値
    distribute(1_000_007, first, second);
    assert(first == 7);
    assert(second == 1_000_000);
}

void main() {
    int first;
    int second;

    distribute(123, first, second);
    writeln("first: ", first, " second: ", second);
}
