module pind.samples.ja.concurrency.concurrency_16;

import std.stdio;
import std.concurrency;
import core.thread;

struct Exit {
}

void main() {
    // パートナー名が"second"のスレッド
    auto first = spawn(&player, "second");
    register("first", first);
    scope(exit) unregister("first");

    // パートナー名が"first"のスレッド
    auto second = spawn(&player, "first");
    register("second", second);
    scope(exit) unregister("second");

    Thread.sleep(2.seconds);

    prioritySend(first, Exit());
    prioritySend(second, Exit());

    // unregister()の呼び出しが成功するには、main()は
    // workerが終了するまで待機する必要がある。
    thread_joinAll();
}

void player(string nameOfPartner) {
    Tid partner;

    while (partner == Tid.init) {
        Thread.sleep(1.msecs);
        partner = locate(nameOfPartner);
    }

    bool isDone = false;

    while (!isDone) {
        partner.send("hello " ~ nameOfPartner);
        receive(
            (string message) {
                writeln("Message: ", message);
                Thread.sleep(500.msecs);
            },

            (Exit message) {
                writefln("%s, I am exiting.", nameOfPartner);
                isDone = true;
            });
    }
}
