module pind.samples.ja.concurrency.concurrency_12;

import std.stdio;
import std.concurrency;

void main() {
    spawn(&intermediaryFunc);
}

void intermediaryFunc() {
    auto worker = spawn(&workerFunc);
    worker.send(1);
    worker.send(2);
}  // ← 2つのメッセージを送信した後、終了する

void workerFunc() {
    while (true) {
        auto m = receiveOnly!int(); // ← 所有者が終了した場合、
                                    //   例外が
                                    //   スローされる。
        writeln("Message: ", m);
    }
}
