module pind.samples.ja.special_functions.special_functions_7;

import std.stdio;
import std.datetime;

struct Logger {
    File file;

    this(File file) {
        this.file = file;
        log("Started");
    }

    ~this() {
        log("Finishing");    // ← 最後のメッセージとなる予定
    }

    void log(string message) {
        file.writefln("%s %s", Clock.currTime(), message);
    }
}

void main() {
    auto logger = Logger(stdout);

    logger.log("Working inside main");
    logger.log("Calling foo");
    foo(logger);
    logger.log("Back to main");
}

void foo(Logger logger) {
    logger.log("Working inside foo");
}
