module pind.samples.ja.nested.nested_5;

class OuterClass {
    int outerMember;

    class NestedClass {
        int func() {
            /* ネストされたクラスは、外側のクラスのメンバーに
             * アクセスできる。 */
            return outerMember * 2;
        }

        OuterClass context() {
            /* ネストされたクラスは、'.outer'によって、その外側のオブジェクト
             * (つまりそのコンテキスト)にアクセスできる。 */
            return this.outer;
        }
    }

    NestedClass algorithm() {
        /* 外側のクラスは、'.new'によって、
         * ネストされたオブジェクトを構築できる。 */
        return this.new NestedClass();
    }
}

void main() {
    auto outerObject = new OuterClass();

    /* 外側のクラスのメンバー関数は、
     * ネストされたオブジェクトを返している: */
    auto nestedObject = outerObject.algorithm();

    /* ネストされたオブジェクトは、プログラム内で使用される: */
    nestedObject.func();

    /* 当然、nestedObjectのコンテキストは
     * outerObjectと同じだ: */
    assert(nestedObject.context() is outerObject);
}
