module pind.samples.ja.interface.interface_4;

import std.stdio;

/* このインターフェースはemitSound()を必要とする。 */
interface SoundEmitter {
    string emitSound();
}

/* このクラスはemitSound()だけを実装すれば良い。 */
class Bell : SoundEmitter {
    string emitSound() {
        return "ding";
    }
}

/* このインターフェースはさらにadjustTuning()を必要とする。 */
interface MusicalInstrument : SoundEmitter {
    void adjustTuning();
}

/* このクラスはemitSound()とadjustTuning()の両方を
 * 実装する必要がある。 */
class Violin : MusicalInstrument {
    string emitSound() {
        return "♩♪♪";
    }

    void adjustTuning() {
        // ... バイオリンの調律 ...
    }
}

/* このインターフェースはtalk()とlisten()を必要とする。 */
interface CommunicationDevice {
    void talk(string message);
    string listen();
}

/* このクラスはemitSound()、talk()、およびlisten()を
 * 実装する必要がある。 */
class Phone : SoundEmitter, CommunicationDevice {
    string emitSound() {
        return "rrring";
    }

    void talk(string message) {
        // ... メッセージを行に追加 ...
    }

    string listen() {
        string soundOnTheLine;
        // ... 行からメッセージを取得 ...
        return soundOnTheLine;
    }
}

class Clock {
    // ... Clockの実装 ...
}

/* このクラスはemitSound()のみを実装する必要がある。 */
class AlarmClock : Clock, SoundEmitter {
    string emitSound() {
        return "beep";
    }

    // ... AlarmClockの実装 ...
}

void main() {
    SoundEmitter[] devices;

    devices ~= new Bell;
    devices ~= new Violin;
    devices ~= new Phone;
    devices ~= new AlarmClock;

    foreach (device; devices) {
        writeln(device.emitSound());
    }
}
