module pind.samples.ja.fibers.fibers_5;

import std.stdio;
import std.range;
import std.concurrency;

/* このエイリアスは、std.range.Generatorとの名前衝突を
 * 解決するために使用される。 */
alias FiberRange = std.concurrency.Generator;

void fibonacciSeries() {
    int current = 0;
    int next = 1;

    while (true) {
        yield(current);

        const nextNext = current + next;
        current = next;
        next = nextNext;
    }
}

void main() {
    auto series = new FiberRange!int(&fibonacciSeries);
    writefln("%(%s %)", series.take(10));
}
