module pind.samples.ja.fibers.fibers_4;

import core.thread;

/* これは、各要素を生成し、
 * その後、その要素に'ref'パラメータを設定するファイバー関数だ。 */
void fibonacciSeries(ref int current) {                 // (1)
    current = 0;    // 'current'はパラメータであることに注意
    int next = 1;

    while (true) {
        Fiber.yield();                                  // (2)
        /* 次のcall()はこの地点から続行される */ // (3)

        const nextNext = current + next;
        current = next;
        next = nextNext;
    }
}

void main() {
    int current;                                        // (1)
                         // (4)
    Fiber fiber = new Fiber(() => fibonacciSeries(current));

    foreach (_; 0 .. 10) {
        fiber.call();                                   // (5)

        import std.stdio;
        writef("%s ", current);
    }
}
