module pind.samples.ja.arrays.arrays_solution_2;

import std.stdio;
import std.algorithm;

void main() {
    // 入力から読み込まれる値の数がわからないため、
    // 動的配列を使用する
    int[] odds;
    int[] evens;

    writeln("Please enter integers (-1 to terminate):");

    while (true) {

        // 値を読み込む
        int value;
        readf(" %s", &value);

        // 特別な値-1はループを中断する
        if (value == -1) {
            break;
        }

        // 値が奇数か偶数かに応じて、対応する配列に追加する。
        // 2で割った余りがなければ、
        // その値は偶数である。
        if ((value % 2) == 0) {
            evens ~= value;

        } else {
            odds ~= value;
        }
    }

    // 奇数と偶数の配列は別々にソートされる
    sort(odds);
    sort(evens);

    // 2つの配列を結合して新しい配列を作成する
    int[] result;
    result = odds ~ evens;

    writeln("First the odds then the evens, sorted:");

    // ループで配列の要素を表示する
    int i;
    while (i < result.length) {
        write(result[i], " ");
        ++i;
    }

    writeln();
}
