module pind.samples.ja.ranges.ranges_10;

import std.traits;
import std.stdio;
import std.algorithm;

struct MultiFile {
    string delimiter;
    File[] files;

    this(string delimiter, string[] fileNames...) {
        this.delimiter = delimiter;

        /* stdoutは常に含まれる */
        this.files ~= stdout;

        /* 各ファイル名に対応するFileオブジェクト */
        foreach (fileName; fileNames) {
            this.files ~= File(fileName, "w");
        }
    }

    // これは配列(文字列は不可)を受け取るバージョンだ
    void put(T)(T slice)
            if (isArray!T && !isSomeString!T) {
        foreach (element; slice) {
            // 注意: これは、以下の別のバージョンの
            // put()への呼び出し
            put(element);
        }
    }

    // これは、配列以外の値と文字列を受け取るバージョンである
    void put(T)(T value)
            if (!isArray!T || isSomeString!T) {
        foreach (file; files) {
            file.write(value, delimiter);
        }
    }
}
// ...

void main() {
    auto output = MultiFile("\n", "output_0", "output_1");
    copy([ 1, 2, 3], output);
    copy([ "red", "blue", "green" ], output);
}
