module pind.samples.ja.pointers.pointers_3;

import std.stdio;

class Pen {
    double ink;

    this() {
        ink = 15;
    }

    void use(double amount) {
        ink -= amount;
    }
}

void main() {
    auto pen = new Pen;
    auto otherPen = pen;  // ← 両方の変数が
                          //   同じオブジェクトへのアクセスを提供する

    writefln("Before: %s %s", pen.ink, otherPen.ink);

    pen.use(1);          // ← 同じオブジェクトが使用される
    otherPen.use(2);     // ← 同じオブジェクトが使用される

    writefln("After : %s %s", pen.ink, otherPen.ink);
}
