/* 注意: このプログラムはコンパイルに失敗する可能性がある。 */

module pind.samples.ja.functions_more.functions_more_3;

import std.stdio;
import std.exception;

int mutableGlobal;
const int constGlobal;
immutable int immutableGlobal;

void impureFunction() {
}

int pureFunction(ref int i, int[] slice) pure {
    // 例外をスローできる:
    enforce(slice.length >= 1);

    // パラメータを変更できる:
    i = 42;
    slice[0] = 43;

    // 不変のグローバル状態にアクセスできる:
    i = constGlobal;
    i = immutableGlobal;

    // 新しい式を使用できる:
    auto p = new int;

    // 変更可能なグローバル状態にアクセスできない:
    i = mutableGlobal;    // ← コンパイルエラー

    // 入力および出力操作を実行できない:
    writeln(i);           // ← コンパイルエラー

    static int mutableStatic;

    // 変更可能な静的状態にアクセスできない:
    i = mutableStatic;    // ← コンパイルエラー

    // 純粋でない関数を呼び出せない:
    impureFunction();     // ← コンパイルエラー

    return 0;
}

void main() {
    int i;
    int[] slice = [ 1 ];
    pureFunction(i, slice);
}
