module pind.samples.ja.exceptions.exceptions_10;

import std.stdio;
import std.exception;
import std.string;

void useTheFile(string fileName) {
    auto file = File(fileName, "r");
    // ...
}

string read_string(string prompt) {
    write(prompt, ": ");
    return strip(readln());
}

void main() {
    bool is_fileUsed = false;

    while (!is_fileUsed) {
        try {
            useTheFile(
                read_string("Please enter a file name"));

            /* この行に到達したら、
             * useTheFile()関数が正常に完了したことを意味する。
             * これは、ファイル名が
             * 有効であったことを示している。
             *
             * これで、ループフラグの値を設定して、
             * whileループを終了することができる。 */
            is_fileUsed = true;
            writeln("The file has been used successfully");

        } catch (std.exception.ErrnoException exc) {
            stderr.writeln("This file could not be opened");
        }
    }
}
