module pind.samples.ja.enum_.enum_solution_1;

import std.stdio;
import std.conv;

enum Operation { exit, add, subtract, multiply, divide }

void main() {
    // サポートされている操作を表示する
    write("Operations - ");
    for (Operation operation;
         operation <= Operation.max;
         ++operation) {

        writef("%d:%s ", operation, operation);
    }
    writeln();

    // ユーザーが終了するまで無条件ループ
    while (true) {
        write("Operation? ");

        // 入力は、列挙型の実際の型(int)で読み込む必要がある
        //
        int operationCode;
        readf(" %s", &operationCode);

        /* この時点から、マジック定数の代わりに列挙型の値を使用する
         * ようになる。したがって、intで読み込まれた操作コードは、
         * 対応する列挙型の値に変換する必要がある。
         *
         *
         * (型変換については、
         * 後の章で詳しく説明する。) */
        Operation operation = cast(Operation)operationCode;

        if ((operation < Operation.min) ||
            (operation > Operation.max)) {
            writeln("ERROR: Invalid operation");
            continue;
        }

        if (operation == Operation.exit) {
            writeln("Goodbye!");
            break;
        }

        double first;
        double second;
        double result;

        write(" First operand? ");
        readf(" %s", &first);

        write("Second operand? ");
        readf(" %s", &second);

        switch (operation) {

        case Operation.add:
            result = first + second;
            break;

        case Operation.subtract:
            result = first - second;
            break;

        case Operation.multiply:
            result = first * second;
            break;

        case Operation.divide:
            result = first / second;
            break;

        default:
            throw new Exception(
                "ERROR: This line should have never been reached.");
        }

        writeln("        Result: ", result);
    }
}
