module pind.samples.ja.templates_more.templates_more_2;

import std.stdio;
class Sink {
    string content;

    void put(T)(auto ref const T value) {
        import std.conv;
        content ~= value.to!string;
    }
}

class SpecialSink : Sink {
    /* 次のテンプレート定義は、スーパークラス
     * のテンプレートインスタンスをオーバーライドしない; これらの名前を
     * 非表示にする。 */
    void put(T)(auto ref const T value) {
        import std.string;
        super.put(format("{%s}", value));
    }
}

void fillSink(Sink sink) {
    /* 次の関数呼び出しは仮想ではない。
     * パラメータ'sink'は型'Sink'であるため、呼び出しは
     * 常にSinkの'put'テンプレートインスタンスに
     * ディスパッチされる。 */

    sink.put(42);
    sink.put("hello");
}

void main() {
    auto sink = new SpecialSink();
    fillSink(sink);

    import std.stdio;
    writeln(sink.content);
}
