module pind.samples.ja.struct_.struct_solution_1;

import std.stdio;
import std.random;
import std.algorithm;

struct Card {
    dchar suit;
    dchar value;
}

void printCard(Card card) {
    write(card.suit, card.value);
}

Card[] newSuit(dchar suit)
in {
    assert((suit == '♠') ||
           (suit == '♡') ||
           (suit == '♢') ||
           (suit == '♣'));

} out (result) {
    assert(result.length == 13);

} do {
    Card[] suitCards;

    foreach (value; "234567890JQKA") {
        suitCards ~= Card(suit, value);
    }

    return suitCards;
}

Card[] newDeck()
out (result) {
    assert(result.length == 52);

} do {
    Card[] deck;

    deck ~= newSuit('♠');
    deck ~= newSuit('♡');
    deck ~= newSuit('♢');
    deck ~= newSuit('♣');

    return deck;
}

void shuffle(Card[] deck, int repetition) {
    /* 注釈: より良いアルゴリズムは、デッキを
     *       最初から最後まで順に、各要素を
     *       その時点から最後までにある要素の中からランダムに選んだ要素と
     *       入れ替えることだ。
     *
     * std.algorithmモジュールからrandomShuffle()を呼び出すと
     * さらに良い。このモジュールは、
     * 同じアルゴリズムをすでに適用している。randomShuffle()の使用方法については、
     * main()のコメントを参照。 */
    foreach (i; 0 .. repetition) {
        // 2つの要素をランダムに選択する
        immutable first = uniform(0, deck.length);
        immutable second = uniform(0, deck.length);

        swap(deck[first], deck[second]);
    }
}

void main() {
    Card[] deck = newDeck();

    shuffle(deck, 100);
    /* 注釈: 上記のshuffle()の呼び出しの代わりに、
     *       次の行のようにrandomShuffle()を呼び出す方が
     *       良い:
     *
     * randomShuffle(deck);
     */
    foreach (card; deck) {
        printCard(card);
        write(' ');
    }

    writeln();
}
