module pind.samples.ja.struct_.struct_5;

import std.stdio;

struct Point {
    // 各オブジェクトの識別子
    size_t id;

    int line;
    int column;

    // 次に構築するオブジェクトのID
    static size_t nextId;
}

Point makePoint(int line, int column) {
    size_t id = Point.nextId;
    ++Point.nextId;

    return Point(id, line, column);
}

void main() {
    auto top = makePoint(7, 0);
    auto middle = makePoint(8, 0);
    auto bottom =  makePoint(9, 0);

    writeln(top.id);
    writeln(middle.id);
    writeln(bottom.id);
}
