module pind.samples.ja.parameter_flexibility.parameter_flexibility_5;

int[] numbersForLaterUse;

void foo(int[] numbers...) {
    /* これはfoo()の可変長引数版であるため、
     * スライスを格納する前に要素のコピーを
     * 作成する必要がある。 */
    numbersForLaterUse = numbers.dup;
}

void foo(int[] numbers) {
    /* これはfoo()の非可変長引数版であるため、
     * スライスをそのまま格納できる。 */
    numbersForLaterUse = numbers;
}

struct S {
    string[] namesForLaterUse;

    void foo(string[] names...) {
        /* これはS.foo()の可変長引数版であるため、
         * スライスを格納する前に
         * 要素のコピーを作成する必要がある。 */
        namesForLaterUse = names.dup;
    }

    void foo(string[] names) {
        /* これはS.foo()の非可変長引数版であるため、
         * スライスをそのまま格納できる。 */
        namesForLaterUse = names;
    }
}

void bar() {
    // この呼び出しは、可変引数関数に送信される。
    foo(1, 10, 100);

    // この呼び出しは適切なスライス関数にディスパッチされる。
    foo([ 2, 20, 200 ]);

    auto s = S();

    // の呼び出しは、可変引数関数に送信される。
    s.foo("hello", "world");

    // この呼び出しは適切なスライス関数にディスパッチされる。
    s.foo([ "hi", "moon" ]);

    // ...
}

void main() {
    bar();
}
