module pind.samples.ja.parallelism.parallelism_3;

import std.stdio;
import std.parallelism;
import std.array;
import core.thread;

/* 0.5秒ごとに'id'の最初の文字を出力する。
 * 計算を行う関数をシミュレートするために、
 * 任意に値1を返す。この結果は後でmainで使用される。 */
int anOperation(string id, int duration) {
    writefln("%s will take %s seconds", id, duration);

    foreach (i; 0 .. (duration * 2)) {
        Thread.sleep(500.msecs);  /* 0.5秒 */
        write(id.front);
        stdout.flush();
    }

    return 1;
}

void main() {
    /* anOperation()を実行するタスクオブジェクトを構築する。
     * ここで指定する関数パラメータは、
     * タスク関数の関数パラメータとして
     * 渡される。 */
    auto theTask = task!anOperation("theTask", 5);

    /* タスクオブジェクトを開始する */
    theTask.executeInNewThread();

    /* 'theTask'の実行が継続すると、'anOperation()'が
     * 再び呼び出される。今回はmain内で直接呼び出される。 */
    immutable result = anOperation("main's call", 3);

    /* この時点で、mainから直接開始された操作は
     * 完了していることは確実だ。
     * これは、この操作はタスクとしてではなく、通常の
     * 関数呼び出しによって開始されたためだ。 */

    /* 一方、この時点では、'theTask'がその操作を
     * 完了したかどうかはまだ
     * 定かではない。yieldForce()は、タスクが
     * その操作を完了するまで待機し、タスクが完了した場合に
     * のみ戻ってくる。その戻り値は、
     * タスク関数、つまりanOperation()の戻り値である。 */
    immutable taskResult = theTask.yieldForce();

    writeln();
    writefln("All finished; the result is %s.",
             result + taskResult);
}
