module pind.samples.ja.literals.literals_1;

import std.stdio;

void main() {
    writeln("\n--- these are written in decimal ---");

    // intに適合するため、型はintになる
    writeln(       2_147_483_647, "\t\t",
            typeof(2_147_483_647).stringof);

    // intに適合せず、10進数であるため、型はlongになる
    writeln(       2_147_483_648, "\t\t",
            typeof(2_147_483_648).stringof);

    writeln("\n--- these are NOT written in decimal ---");

    // intに適合するため、型はintになる
    writeln(       0x7FFF_FFFF, "\t\t",
            typeof(0x7FFF_FFFF).stringof);

    // intに適合せず、10進数でもないため、型はuintになる
    writeln(       0x8000_0000, "\t\t",
            typeof(0x8000_0000).stringof);

    // uintに収まらず、10進数でもないため、型はlongになる
    writeln(       0x1_0000_0000, "\t\t",
            typeof(0x1_0000_0000).stringof);

    // longに収まらず、10進数でもないため、型はulongになる
    writeln(       0x8000_0000_0000_0000, "\t\t",
            typeof(0x8000_0000_0000_0000).stringof);
}
