module pind.samples.ja.lifetimes.lifetimes_1;

void main() {
    int main_in;      /* main_inの値は、
                       * パラメータにコピーされる。 */

    int main_ref;     /* main_refは、
                       * それ自体として関数に渡される。 */

    int main_out;     /* main_outは、
                       * それ自体として関数に渡される。その値は
                       * 関数に入った時点でint.initに設定される。 */

    foo(main_in, main_ref, main_out, aCalculation());
}

void foo(
    in int p_in,       /* p_inの寿命は、
                        * 関数に入った時点で始まり、
                        * 関数から出た時点で終わる。 */

    ref int p_ref,     /* p_refはmain_refの別名だ。 */

    out int p_out,     /* p_outはmain_outの別名だ。
                        * その値は、
                        * 関数に入った時点でint.initに設定される。 */

    lazy int p_lazy) { /* p_lazyの寿命は、
                        * 使用された時点で始まり、その使用が
                        * 終了すると終了する。その値は、
                        * p_lazyが関数内で使用されるたびに
                        * aCalculation()を呼び出すことで計算される。 */
    // ...
}

int aCalculation() {
    int result;
    // ...
    return result;
}
