module pind.samples.ja.functions.functions_5;

import std.stdio;

enum totalLines = 20;
enum totalColumns = 60;

/* 次の行の'alias'は、'Line'を
 * dchar[totalColumns]の別名にする。プログラムの残りの部分で使用される'Line'は、
 * この時点からdchar[totalColumns]を意味する。
 *
 *
 * また、'Line'は固定長配列であることに注意。  */
alias Line = dchar[totalColumns];

/* Linesの動的配列は'Canvas'として別名付けられている。 */
alias Canvas = Line[];

/* キャンバスを1行ずつ表示する。 */
void print(Canvas canvas) {
    foreach (line; canvas) {
        writeln(line);
    }
}

/* キャンバスの指定位置にドットを配置する。ある意味で、
 * キャンバスに"描画"する。 */
void putDot(Canvas canvas, int line, int column) {
    canvas[line][column] = '#';
}

/* 指定位置から指定した長さの垂直線を
 * 描写する。 */
void drawVerticalLine(Canvas canvas,
                      int line,
                      int column,
                      int length) {
    foreach (lineToPaint; line .. line + length) {
        putDot(canvas, lineToPaint, column);
    }
}

void main() {
    Line emptyLine = '.';

    /* 空のキャンバス */
    Canvas canvas;

    /* 空の行を追加してキャンバスを構築する */
    foreach (i; 0 .. totalLines) {
        canvas ~= emptyLine;
    }

    /* キャンバスを使用する */
    putDot(canvas, 7, 30);
    drawVerticalLine(canvas, 5, 10, 4);

    print(canvas);
}
