module pind.samples.ja.destroy.destroy_1;

class LifetimeObserved {
    int[] array;           // ← 各オブジェクトに属する

    static size_t counter; // ← すべてのオブジェクトで共有される

    this() {
        /* 比較的大きな配列を使用して、各オブジェクトが
         * 大量のメモリを消費するようにしている。これにより、
         * ガベージコレクタがオブジェクトのデストラクタを
         * より頻繁に呼び出し、より多くのオブジェクトのためのスペースを
         * 解放するようになることを期待している。 */
        array.length = 30_000;

        /* 構築中のこのオブジェクトのカウンターを
         * インクリメントする。 */
        ++counter;
    }

    ~this() {
        /* 破壊中のこのオブジェクトのカウンターを
         * デクリメントする。 */
        --counter;
    }
}
import std.stdio;

void main() {
    foreach (i; 0 .. 20) {
        auto variable = new LifetimeObserved;  // ← 開始
        write(LifetimeObserved.counter, ' ');
    } // ← 終了

    writeln();
}
