module pind.samples.ja.concurrency.concurrency_13;

import std.stdio;
import std.concurrency;

void main() {
    auto worker = spawnLinked(&workerFunc);

    while (true) {
        auto m = receiveOnly!int(); // ← workerが
                                    //   終了した場合、例外が
                                    //   スローされる。
        writeln("Message: ", m);
    }
}

void workerFunc() {
    ownerTid.send(10);
    ownerTid.send(20);
}  // ← 2つのメッセージを送信した後、終了する
